/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.bonus.action;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

// import net.sf.jasperreports.engine.JRException;
// import net.sf.jasperreports.engine.JRExporter;
// import net.sf.jasperreports.engine.JRExporterParameter;
// import net.sf.jasperreports.engine.JasperFillManager;
// import net.sf.jasperreports.engine.JasperPrint;
// import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
// import net.sf.jasperreports.engine.export.JRPdfExporter;

//import jp.co.u_nic.base.CalculateAction;
//import jp.co.u_nic.base.UnicVo;
//import jp.co.u_nic.common.dto.UmConfDto;
//import jp.co.u_nic.common.dto.UmStationDto;

import jp.mosp.common.dto.MosPConfDto;
import jp.mosp.payroll.base.PayrollVo;
import jp.mosp.payroll.base.PayrollAction;

import jp.mosp.common.vo.MosPVo;

import jp.mosp.payroll.bonus.dto.BonusDetailDto;

import jp.mosp.payroll.bonus.vo.BonusCalcVo;
import jp.mosp.payroll.bonus.vo.BonusCardVo;


import jp.mosp.payroll.bonus.dao.PdBonusDao;
import jp.mosp.payroll.bonus.dto.PdBonusDto;

import jp.mosp.payroll.bonus.BonusConst;

import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;

/**
 * ^׏o͋@\񋟂B<br><br>
 * ^vZʂANw肵đΏۑS̋^ׂꊇo͂B<br>
 * ܂^׉ʂAIЈ̑INɂ鋋^ׂo͂B<br>
 */
public class BonusDetailAction extends PayrollAction {
	
	// R}h
	private static final String CMD_BONUS_DETAIL_ALL = "P2031";
	private static final String CMD_BONUS_DETAIL_ONE = "P2032";
	
	// ev[gXMLt@CpX
	private static final String template = "/template/bonusDetail.jasper";
	
	/**
	 * RXgN^B<br>
	 * V[PXssvݒsB<br>
	 */
	public BonusDetailAction() {
		super();
		setNeedProcSeq(false);
	}
	
	/**
	 * ܗ^ׂo͂B<br>
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// PAYROLLmF
		if (cmd.equals(CMD_BONUS_DETAIL_ALL)) {
			// VO̎擾
			BonusCalcVo vo = (BonusCalcVo)session.getAttribute(MospConst.ATT_FORMER_VO);
			vo.clearMessage();
			vo.clearErrField();
			vo.initVo(cfg, msg, cmd, aspUser, user);
			// p[^擾
			vo.setYearParams(request);
			// Ώ۔N擾
			Date date = vo.getDate(vo.getPltDetailYear(), vo.getPltDetailMonth(), "1");
			Date payday = vo.getDate(vo.getPltDetailYear(), vo.getPltDetailMonth(), vo.getPltDetailDay());
			// ܗ^׃f[^쐬
			List<BonusDetailDto> list = getBonusDetail(date, payday, null, vo.getPltStationCode(), (PayrollVo)vo);
			// [쐬
			String fileName = vo.getPltDetailYear () + BonusConst.FILE_NAME_SEPARATOR
							+ vo.getPltDetailMonth() + BonusConst.FILE_NAME_SEPARATOR
							+ vo.getPltDetailDay() + BonusConst.FILE_NAME_SEPARATOR
							+ BonusConst.FILE_BONUS_DETAIL;
			request.setAttribute(MospConst.ATT_FILE_NAME, fileName);
			// [쐬yѐݒ
//			request.setAttribute(MospConst.ATT_FILE_OBJECT, print(
//					cfg.getProperty(MospConst.PPT_APP_DOCBASE) + template, list));
		} else if (cmd.equals(CMD_BONUS_DETAIL_ONE)) {
			// VO̎擾
			BonusCardVo vo = new BonusCardVo();
			vo = (BonusCardVo)getStoredVo(vo.getClassName());
			vo.clearMessage();
			vo.clearErrField();
			vo.initVo(cfg, msg, cmd, aspUser, user);
			// p[^擾
			vo.setParams(request);
			// Ώ۔N擾
			Date date = vo.getDate(vo.getPltYear(), vo.getPltMonth(), "1");
			Date payday = vo.getDate(vo.getPltYear(), vo.getPltMonth(), vo.getPltDay());
			// ܗ^׃f[^쐬
			List<BonusDetailDto> list = getBonusDetail(date, payday, vo.getHidKCode(), (String)null, (PayrollVo)vo);
			// [쐬
			String fileName = vo.getPltYear () + BonusConst.FILE_NAME_SEPARATOR
							+ vo.getPltMonth() + BonusConst.FILE_NAME_SEPARATOR
							+ vo.getPltDay() + BonusConst.FILE_NAME_SEPARATOR
							+ vo.getHidKCode()       + BonusConst.FILE_NAME_SEPARATOR
							+ BonusConst.FILE_BONUS_DETAIL;
			request.setAttribute(MospConst.ATT_FILE_NAME, fileName);
			// [쐬yѐݒ
//		request.setAttribute(MospConst.ATT_FILE_OBJECT, print(
//					cfg.getProperty(MospConst.PPT_APP_DOCBASE) + template, list));
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	/**
	 * ܗ^׃f[^쐬B<br>
	 * @param targetMonth 쐬Ώ۔N
	 * @param kCode       쐬ΏێЈR[h(nullȂS)
	 * @param vo          VO
	 * @return ܗ^׃f[^Xg
	 * @throws Exception
	 */
	private List<BonusDetailDto> getBonusDetail(
			Date targetMonth, Date payday, String kCode, String stationCode, PayrollVo vo
	) throws Exception {
		// ܗ^f[^擾
		PdBonusDao dao = new PdBonusDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		confirmPayrollAuth();
		// aݒ擾
		List<MosPConfDto> listConf = getConfList (BonusConst.CONF_ID_JP_IMP_CAL);
		String[][]      aryEra   = getCodeArray(BonusConst.TID_JAPANESE      );
		// \pN擾(Ώ۔N+1)
//		String strDate[] = vo.getJpImperialCal(listConf, targetMonth);
//		strDate[0]       = getCodeName(strDate[0], aryEra);
		// ܗ^f[^擾
		List<PdBonusDto> listBonus = dao.findForOutputDetail(targetMonth, payday , kCode, stationCode);
		// ܗ^׃f[^쐬
		List<BonusDetailDto> list = new ArrayList<BonusDetailDto>();

		/**
		// }bv擾
		Map<String, PmStationDto> mapStation = getStationMap();
		for (Iterator<PdBonusDto> it = listBonus.iterator(); it.hasNext();) {
			PdBonusDto = it.next();
			BonusDetailDto dto = new BonusDetailDto(PdBonusDto, getMapBonusDetail());
			dto.setYear(strDate[0] + strDate[1]);
			dto.setMonth(strDate[2]);
			// cƏR[hݒ
			PmStationDto PmStationDto = mapStation.get(PdBonusDto.getStationCode());
			// ʃR[h擾
			dto.setBelongCode(PmStationDto.getBelongCode());
			list.add(dto);
		}
		// ܗ^f[^mF
		if (list.size() == 0) {
			setVo(vo);
			setUrl(vo.getRetUrl());
			String errMessage = MospUtility.getMessage(msg, BonusConst.MSG_NO_BONUS_DETAIL, "");
			addErrMessage(errMessage);
			throw new MospException(BonusConst.EX_NO_PAYMENT_DETAIL, errMessage);
		}
		
		// rNX
		Comparator<BonusDetailDto> comp = new Comparator<BonusDetailDto>() {
			public int compare(BonusDetailDto obj0, BonusDetailDto obj1) {
				String st1 = obj0.getBelongCode();
				String st2 = obj1.getBelongCode();
				return st1.compareTo(st2);
			}
		};
		// \[g
		Collections.sort(list, comp); // z\[g

		
*/
		return list;
	}
}
	
	/**
	 * PDF[쐬B<br>
	 * @param template ev[gt@CpX
	 * @param list     o͑ΏۃXg
	 * @return PDFo̓IuWFNg
	 * @throws MospException
	 */
/**
	private JRExporter print(
			String template, List<BonusDetailDto> list
	) throws MospException {
		try {
			// IoChf[^
			JRBeanCollectionDataSource ds = new JRBeanCollectionDataSource(list);
			// [쐬
			JasperPrint print = JasperFillManager.fillReport(template, new HashMap(), ds);
			// PDFo͏
			JRPdfExporter exporter = new JRPdfExporter();
			exporter.setParameter(JRExporterParameter.JASPER_PRINT, print);
			return exporter;
		} catch (JRException e) {
			throw new MospException(BonusConst.EX_PRINT_FAILED, MospUtility.getStackTrace(e));
		}
	}
}
*/
